

<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
		    <div class="card-header d-flex align-items-center">
				<span class="header-title"><?php echo e(_lang('Database Backups')); ?></span>
				<a class="btn btn-primary btn-xs ml-auto" href="<?php echo e(route('database_backups.create')); ?>"><i class="ti-plus"></i>&nbsp;<?php echo e(_lang('Create New Backup')); ?></a>
			</div>
			<div class="card-body">
				<table id="database_backups_table" class="table table-bordered data-table">
					<thead>
					    <tr>
						    <th><?php echo e(_lang('Created At')); ?></th>
						    <th><?php echo e(_lang('File')); ?></th>
							<th><?php echo e(_lang('Created By')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
					    </tr>
					</thead>
					<tbody>
					    <?php $__currentLoopData = $databasebackups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $databasebackup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					    <tr data-id="row_<?php echo e($databasebackup->id); ?>">
							<td class='created_at'><?php echo e($databasebackup->created_at); ?></td>
							<td class='file'><?php echo e($databasebackup->file); ?></td>
							<td class='user_id'><?php echo e($databasebackup->created_by->name); ?></td>

							<td class="text-center">
								<span class="dropdown">
									<button class="btn btn-primary dropdown-toggle btn-xs" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<?php echo e(_lang('Action')); ?>


									</button>
									<form action="<?php echo e(route('database_backups.destroy_database_backup', $databasebackup['id'])); ?>" method="post">
										<?php echo csrf_field(); ?>
										<input name="_method" type="hidden" value="DELETE">

										<div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
											<a href="<?php echo e(route('database_backups.download', $databasebackup['id'])); ?>" class="dropdown-item dropdown-view"><i class="ti-download"></i>&nbsp;<?php echo e(_lang('Download')); ?></a>
											<button class="btn-remove dropdown-item" type="submit"><i class="ti-trash"></i>&nbsp;<?php echo e(_lang('Delete')); ?></button>
										</div>
									</form>
								</span>
							</td>
					    </tr>
					    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/administration/database_backup/list.blade.php ENDPATH**/ ?>