<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-12">
		<div class="card">
			<div class="card-header">
				<span class="header-title"><?php echo e(_lang('Update Payment Gateway')); ?></span>
			</div>
			<div class="card-body">
				<form method="post" class="validate" autocomplete="off" action="<?php echo e(route('payment_gateways.update', $id)); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<input name="_method" type="hidden" value="PATCH">
					<div class="row">
						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Name')); ?></label>
								<input type="text" class="form-control" name="name" value="<?php echo e($paymentgateway->name); ?>" required>
							</div>
						</div>

						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Image')); ?></label>
								<input type="file" class="form-control dropify" name="image" data-allowed-file-extensions="png jpg" data-default-file="<?php echo e(asset('public/backend/images/gateways/'.$paymentgateway->image)); ?>">
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Status')); ?></label>
								<select class="form-control auto-select" data-selected="<?php echo e($paymentgateway->status); ?>" name="status" id="gateway_status" required>
									<option value="0"><?php echo e(_lang('Disable')); ?></option>
									<option value="1"><?php echo e(_lang('Enable')); ?></option>
								</select>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Currency')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e($paymentgateway->currency); ?>" id="gateway_currency" name="currency">
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = $paymentgateway->supported_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>


						<?php $__currentLoopData = $paymentgateway->parameters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<?php if($key != 'environment'): ?>
								<div class="col-lg-6">
									<div class="form-group">
										<label class="control-label"><?php echo e(strtoupper(str_replace('_',' ',$key))); ?></label>
										<input type="text" class="form-control" value="<?php echo e($value); ?>" name="parameter_value[<?php echo e($key); ?>]">
									</div>
								</div>
							<?php else: ?>
								<div class="col-lg-12">
									<div class="form-group">
										<label class="control-label"><?php echo e(strtoupper(str_replace('_',' ',$key))); ?></label>
										<select class="form-control auto-select" data-selected="<?php echo e($value); ?>" name="parameter_value[<?php echo e($key); ?>]">
											<option value="sandbox"><?php echo e(_lang('Sandbox')); ?></option>
											<option value="live"><?php echo e(_lang('Live')); ?></option>
										</select>
									</div>
								</div>
							<?php endif; ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

						<?php if($paymentgateway->is_crypto == 0): ?>
						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Exchange Rate')); ?></label>
								<div class="input-group">
									<input type="text" class="form-control" name="exchange_rate" id="exchange_rate" value="<?php echo e($paymentgateway->exchange_rate); ?>" <?php echo e($paymentgateway->status == 1 ? 'required' : ''); ?>>
								</div>
								
								<small class="text-info"><i><i class="ti-info-alt"></i> <?php echo e(_lang('Exchange rate will be used to convert your base currency to gateway currency. If your base currency and gateway currency is same then exchange rate will be 1.00')); ?></i></small>
							</div>
						</div>
						<?php else: ?>
						<div class="col-lg-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Exchange Rate')); ?></label>
								<div class="input-group">
									<input type="text" class="form-control" name="exchange_rate" id="exchange_rate" value="<?php echo e($paymentgateway->exchange_rate); ?>" <?php echo e($paymentgateway->status == 1 ? 'required' : ''); ?>>
								</div>
								
								<small class="text-info"><i><i class="ti-info-alt"></i> <?php echo e(_lang('Exchange rate will be used for crypto currency to convert your base currency to USD. If your base currency is USD then exchange rate will be 1.00')); ?></i></small>
							</div>
						</div>
						<?php endif; ?>

						<div class="col-lg-12 mt-4">
							<div class="card">
								<div class="card-header d-flex align-items-center">
									<span class="panel-title"><?php echo e(_lang('Limits & Charges')); ?></span>
									<button type="button" class="btn btn-primary btn-xs ml-auto" id="add-row"><i class="ti-plus"></i>&nbsp;<?php echo e(_lang('Add Row')); ?></button>
								</div>
								<div class="card-body">
									<div class="table-responsive">
										<table id="charge-table" class="table table-bordered">
											<thead>
												<tr>
													<th><?php echo e(_lang('Minimum Amount')); ?></th>
													<th><?php echo e(_lang('Maximum Amount')); ?></th>
													<th><?php echo e(_lang('Fixed Charge')); ?></th>
													<th><?php echo e(_lang('Charge')); ?> (%)</th>
													<th class="text-center"><?php echo e(_lang('Remove')); ?></th>
												</tr>
											</thead>
											<tbody>
												<?php if($paymentgateway->chargeLimits()->count() > 0): ?>
													<?php $__currentLoopData = $paymentgateway->chargeLimits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chargeLimit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
													<tr>
														<td>
															<input type="hidden" name="limit_id[]" value="<?php echo e($chargeLimit->id); ?>">
															<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Minimum Amount')); ?>" name="minimum_amount[]" value="<?php echo e($chargeLimit->minimum_amount); ?>" required>
														</td>
														<td>
															<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Maximum Amount')); ?>" name="maximum_amount[]" value="<?php echo e($chargeLimit->maximum_amount); ?>" required>
														</td>
														<td>
															<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Fixed Charge')); ?>" name="fixed_charge[]" value="<?php echo e($chargeLimit->fixed_charge); ?>" required>
														</td>
														<td>
															<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Charge')); ?> (%)" name="percent_charge[]" value="<?php echo e($chargeLimit->charge_in_percentage); ?>" required>
														</td>
														<td class="text-center">
															<button type="button" class="btn btn-danger btn-xs remove-row"><i class="ti-trash"></i></button>
														</td>
													</tr>
													<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
												<?php else: ?>
												<tr>
													<td>
														<input type="hidden" name="limit_id[]" value="">
														<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Minimum Amount')); ?>" name="minimum_amount[]" value="" required>
													</td>
													<td>
														<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Maximum Amount')); ?>" name="maximum_amount[]" value="" required>
													</td>
													<td>
														<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Fixed Charge')); ?>" name="fixed_charge[]" value="0" required>
													</td>
													<td>
														<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Charge In Percentage')); ?>" name="percent_charge[]" value="0" required>
													</td>
													<td class="text-center">
														<button type="button" class="btn btn-danger btn-xs remove-row"><i class="ti-trash"></i></button>
													</td>
												</tr>
												<?php endif; ?>
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>

						<div class="col-lg-12 mt-2">
							<div class="form-group">
								<button type="submit" class="btn btn-primary "><i class="ti-check-box"></i>&nbsp;<?php echo e(_lang('Save Changes')); ?></button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
	$(document).on('click', '#add-row', function(){
		var row = `<tr>
						<td>
							<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Minimum Amount')); ?>" name="minimum_amount[]" value="" required>
						</td>
						<td>
							<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Maximum Amount')); ?>" name="maximum_amount[]" value="" required>
						</td>
						<td>
							<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Fixed Charge')); ?>" name="fixed_charge[]" value="0" required>
						</td>
						<td>
							<input type="text" class="form-control float-field" placeholder="<?php echo e(_lang('Charge In Percentage')); ?>" name="percent_charge[]" value="0" required>
						</td>
						<td class="text-center">
							<button type="button" class="btn btn-danger btn-xs remove-row"><i class="ti-trash"></i></button>
						</td>
					</tr>`;
		$('#charge-table tbody').append(row);
	});

	$(document).on('click', '.remove-row', function(){
		if($('#charge-table tbody tr').length > 1){
			$(this).closest('tr').remove();
		}else{
			alert('You must set at least one limit');
		}	
	});

</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/payment_gateway/edit.blade.php ENDPATH**/ ?>