<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Revenue Report')); ?></span>
			</div>

			<div class="card-body">

				<div class="report-params">
					<form class="validate" method="post" action="<?php echo e(route('reports.revenue_report')); ?>">
						<div class="row">
              				<?php echo e(csrf_field()); ?>


							<div class="col-lg-3">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Year')); ?></label>
									<select class="form-control auto-select" name="year" data-selected="<?php echo e(isset($year) ? $year : date('Y')); ?>" required>
										<?php for($y = 2020; $y<= date('Y'); $y++): ?>
										<option value="<?php echo e($y); ?>"><?php echo e($y); ?></option>
										<?php endfor; ?>
									</select>
								</div>
							</div>

							<div class="col-lg-3">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Month')); ?></label>
									<select class="form-control auto-select" name="month" data-selected="<?php echo e(isset($month) ? $month : date('m')); ?>" required>
										<?php for($i=1; $i<=12; $i++): ?>
											<option value="<?php echo e($i); ?>"><?php echo e(date('F', mktime(0, 0, 0, $i, 10))); ?></option>
										<?php endfor; ?>
									</select>
								</div>
							</div>

							<div class="col-md-3">
								<div class="form-group">
									<label class="control-label"><?php echo e(_lang('Currency')); ?></label>
									<select class="form-control auto-select" data-selected="<?php echo e(isset($currency_id) ? $currency_id : base_currency_id()); ?>" name="currency_id" required>
										<?php echo e(create_option('currency','id','name','',array('status=' => 1))); ?>

									</select>
								</div>
							</div>

							<div class="col-lg-3">
								<button type="submit" class="btn btn-light btn-sm btn-block mt-26"><i class="icofont-filter"></i> <?php echo e(_lang('Filter')); ?></button>
							</div>
						</form>

					</div>
				</div><!--End Report param-->

				<div class="report-header">
				   <h4><?php echo e(_lang('Revenue Report')); ?> <?php echo e(isset($year) ? _lang('of').' '.date('F', mktime(0, 0, 0, $month, 10)).' '.$year : ''); ?></h4>
				</div>

				<table class="table table-bordered report-table">
					<thead>
					    <img src="<?php echo e(get_logo()); ?>" class="logo"/>
						<th><?php echo e(_lang('Revenue Type')); ?></th>
						<th class="text-right"><?php echo e(_lang('Amount')); ?></th>
					</thead>
					<tbody>
					<?php if(isset($report_data)): ?>

						<?php $currency = currency(get_currency($currency_id)->name); ?>
						<?php $total = 0; ?>

						<?php $__currentLoopData = $report_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $revenue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e(str_replace('_', ' ', $revenue->type)); ?></td>
								<td class="text-right"><?php echo e(decimalPlace($revenue->amount, $currency)); ?></td>
							</tr>
							<?php $total += $revenue->amount; ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><b><?php echo e(_lang('Total Revenue')); ?></b></td>
								<td class="text-right"><b><?php echo e(decimalPlace($total, $currency)); ?></b></td>
							</tr>
					<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/reports/revenue_report.blade.php ENDPATH**/ ?>