<form method="post" class="ajax-submit" autocomplete="off" action="<?php echo e(route('bank_accounts.update', $id)); ?>" enctype="multipart/form-data">
	<?php echo e(csrf_field()); ?>

	<input name="_method" type="hidden" value="PATCH">
	<div class="row px-2">
		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Opening Date')); ?></label>						
				<input type="text" class="form-control datepicker" name="opening_date" value="<?php echo e($bankaccount->getRawOriginal('opening_date')); ?>" readonly>
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Bank Name')); ?></label>						
				<input type="text" class="form-control" name="bank_name" value="<?php echo e($bankaccount->bank_name); ?>" required>
			</div>
		</div>

		<div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Account Name')); ?></label>						
				<input type="text" class="form-control" name="account_name" value="<?php echo e($bankaccount->account_name); ?>" required>
			</div>
		</div>

		<div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Account Number')); ?></label>						
				<input type="text" class="form-control" name="account_number" value="<?php echo e($bankaccount->account_number); ?>" required>
			</div>
		</div>

		<div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Currency')); ?></label>						
				<select class="form-control select2 auto-select" data-selected="<?php echo e($bankaccount->currency_id); ?>" name="currency_id" required>
					<option value=""><?php echo e(_lang('Select One')); ?></option>
					<?php echo e(create_option('currency', 'id', 'name', array('status=' => 1))); ?>

				</select>
			</div>
		</div>

		<div class="col-lg-6">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Opening Balance')); ?></label>						
				<input type="text" class="form-control float-field" name="opening_balance" value="<?php echo e($bankaccount->opening_balance); ?>" readonly>
			</div>
		</div>

		<div class="col-lg-12">
			<div class="form-group">
				<label class="control-label"><?php echo e(_lang('Description')); ?></label>						
				<textarea class="form-control" name="description"><?php echo e($bankaccount->description); ?></textarea>
			</div>
		</div>
	
		<div class="col-lg-12 mt-2">
			<div class="form-group">
			    <button type="submit" class="btn btn-primary"><i class="ti-check-box mr-2"></i> <?php echo e(_lang('Update')); ?></button>
		    </div>
		</div>
	</div>
</form>

<?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/bank_account/modal/edit.blade.php ENDPATH**/ ?>