<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Cash In Hand')); ?></span>
			</div>
			<div class="card-body">
				<?php $date_format = get_option('date_format','Y-m-d'); ?>
				<?php $currency = get_base_currency(); ?>
				<?php $cash_in_hand = []; ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Cash In Hand')); ?></h4>
				   <p><?php echo e(_lang('Date').': '. date($date_format)); ?></p>
				</div>

				<table class="table table-bordered report-table">
					<thead>
                        <th><?php echo e(_lang('Title')); ?></th>
						<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th class="text-right pr-4"><?php echo e(_lang('Amount')); ?> (<?php echo e($c->name); ?>)</th>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</thead>
					<tbody>			
						<tr>
							<td><?php echo e(_lang('Member Deposit')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-success pr-4"><?php echo e(isset($total_deposit[$c->name]) ? '+ '. decimalPlace($total_deposit[$c->name]->total_deposit, currency($c->name)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] = isset($total_deposit[$c->name]) ? $total_deposit[$c->name]->total_deposit : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><?php echo e(_lang('Loan Cash Payment')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-success pr-4"><?php echo e(isset($total_cash_payment[$c->name]) ? '+ '. decimalPlace($total_cash_payment[$c->name]->total_cash_payment, currency($c->name)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] += isset($total_cash_payment[$c->name]) ? $total_cash_payment[$c->name]->total_cash_payment : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><?php echo e(_lang('Bank to Cash Deposit')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-success pr-4"><?php echo e(isset($bank_to_cash_deposit[$c->name]) ? '+ '. decimalPlace($bank_to_cash_deposit[$c->name]->bank_to_cash_deposit, currency($c->name)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] += isset($bank_to_cash_deposit[$c->name]) ? $bank_to_cash_deposit[$c->name]->bank_to_cash_deposit : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><?php echo e(_lang('Member Withdrawal')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-danger pr-4"><?php echo e(isset($total_withdraw[$c->name]) ? '- '. decimalPlace($total_withdraw[$c->name]->total_withdraw, currency($c->name)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] -= isset($total_withdraw[$c->name]) ? $total_withdraw[$c->name]->total_withdraw : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><?php echo e(_lang('Loan Cash Disbursement')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-danger pr-4"><?php echo e(isset($total_cash_disbursement[$c->name]) ? '- '. decimalPlace($total_cash_disbursement[$c->name]->total_cash_disbursement, currency($c->name)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] -= isset($total_cash_disbursement[$c->name]) ? $total_cash_disbursement[$c->name]->total_cash_disbursement : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><?php echo e(_lang('Cash to Bank Deposit')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-danger pr-4"><?php echo e(isset($cash_to_bank_deposit[$c->name]) ? '- '. decimalPlace($cash_to_bank_deposit[$c->name]->cash_to_bank_deposit, currency($c->name)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] -= isset($cash_to_bank_deposit[$c->name]) ? $cash_to_bank_deposit[$c->name]->cash_to_bank_deposit : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><?php echo e(_lang('Expenses')); ?></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right text-danger pr-4"><?php echo e($currency == $c->name ? '- '. decimalPlace($total_expense[0]->total_expense, currency($currency)) : 0); ?></td>						
							<?php $cash_in_hand[$c->name] -= $currency == $c->name ? $total_expense[0]->total_expense : 0; ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tr>
						<tr>
							<td><b><?php echo e(_lang('Cash In Hand')); ?><b></td>
							<?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<td class="text-right pr-4">
								<b><?php echo e(decimalPlace($cash_in_hand[$c->name], currency($currency))); ?></b>
							</td>	
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>					
						</tr>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/reports/cash_in_hand.blade.php ENDPATH**/ ?>