<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <span class="header-title"><?php echo e(_lang('Update User')); ?></span>
            </div>
            <div class="card-body">
                <form method="post" class="validate" autocomplete="off"
                    action="<?php echo e(route('users.update', $id)); ?>" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <input name="_method" type="hidden" value="PATCH">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Name')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="name" value="<?php echo e($user->name); ?>"
                                        required>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Email')); ?></label>
                                <div class="col-xl-9">
                                    <input type="text" class="form-control" name="email" value="<?php echo e($user->email); ?>"
                                        required>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Password')); ?></label>
                                <div class="col-xl-9">
                                    <input type="password" class="form-control" name="password">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('User Type')); ?></label>
                                <div class="col-xl-9">
                                    <select class="form-control auto-select"
                                        data-selected="<?php echo e($user->user_type); ?>" name="user_type" id="user_type" required>
                                        <option value=""><?php echo e(_lang('Select One')); ?></option>
                                        <option value="admin"><?php echo e(_lang('Admin')); ?></option>
                                        <option value="user"><?php echo e(_lang('User')); ?></option>
                                    </select>
                                    <small class="text-primary"><i class="ti-info-alt"></i> <i><?php echo e(_lang('Admin will get full access and user will get role based access only.')); ?></i></small>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('User Role')); ?></label>
                                <div class="col-xl-9">
                                    <select class="form-control select2-ajax" data-href="<?php echo e(route('roles.create')); ?>" data-title="<?php echo e(_lang('Add New Role')); ?>" data-value="id" data-display="name"
                                        data-table="roles" name="role_id" id="role_id">
                                        <option value=""><?php echo e(_lang('Select One')); ?></option>
                                        <?php echo e(create_option("roles","id","name", $user->role_id)); ?>

                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Branch')); ?></label>
                                <div class="col-xl-9">
                                    <select class="form-control select2" name="branch_id" id="user_branch_id">
                                        <option value="all_branch" <?php echo e($user->all_branch_access == 1 ? 'selected' : ''); ?>><?php echo e(_lang('All Branch')); ?></option>
                                        <option value="" <?php echo e($user->all_branch_access == 0 && $user->branch_id == '' ? 'selected' : ''); ?>><?php echo e(get_option('default_branch_name', 'Main Branch')); ?></option>
                                        <?php echo e(create_option("branches", "id", "name", $user->branch_id)); ?>

                                    </select>
                                    <small class="text-primary"><i class="ti-info-alt"></i> <i><?php echo e(_lang('If not assign any branch then user will get default branch access.')); ?></i></small>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Status')); ?></label>
                                <div class="col-xl-9">
                                    <select class="form-control auto-select" data-selected="<?php echo e($user->status); ?>"
                                        name="status" required>
                                        <option value=""><?php echo e(_lang('Select One')); ?></option>
                                        <option value="1"><?php echo e(_lang('Active')); ?></option>
                                        <option value="0"><?php echo e(_lang('In Active')); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-xl-3 col-form-label"><?php echo e(_lang('Profile Picture')); ?></label>
                                <div class="col-xl-9">
                                    <input type="file" class="form-control dropify" name="profile_picture" data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG" data-default-file="<?php echo e(profile_picture($user->profile_picture)); ?>">
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-xl-9 offset-xl-3">
                                    <button type="submit" class="btn btn-primary"><i class="ti-check-box"></i>&nbsp;<?php echo e(_lang('Update User')); ?></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/user/edit.blade.php ENDPATH**/ ?>