<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header">
				<h4 class="header-title text-center"><?php echo e(_lang('Deposit Via').' '.$deposit_method->name); ?></h4>
			</div>
			<div class="card-body">
                <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('deposit.manual_deposit',$deposit_method->id)); ?>" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <div class="row p-2">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"><?php echo e(_lang('Credit Account')); ?></label>
                                <select class="form-control auto-select" data-selected="<?php echo e(old('credit_account')); ?>" name="credit_account" id="credit_account" required>
                                    <option value=""><?php echo e(_lang('Select One')); ?></option>
                                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($account->id); ?>" data-currency="<?php echo e($account->savings_type->currency->name); ?>"><?php echo e($account->account_number); ?> (<?php echo e($account->savings_type->name); ?> - <?php echo e($account->savings_type->currency->name); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"><?php echo e(_lang('Deposit Amount')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="account-currency"><?php echo e($deposit_method->currency->name); ?></span>
                                    </div>
                                    <input type="text" class="form-control float-field" id="amount" name="amount" value="<?php echo e(old('amount')); ?>" required>
                                </div>
                                <p class="text-danger" id="error-msg"></p>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label"><?php echo e(_lang('Converted Amount')); ?> (<?php echo e(_lang('Charge Included')); ?>)</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="gateway-currency"><?php echo e($deposit_method->currency->name); ?></span>
                                    </div>
                                    <input type="text" class="form-control float-field" id="converted_amount" name="converted_amount" value="<?php echo e(old('converted_amount')); ?>" readonly>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12 my-4">						
                            <div class="table-responsive">
                                <table id="charge-table" class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th colspan="2" class="text-center bg-light"><?php echo e(_lang('Limits & Charges')); ?></th>
                                        </tr>
                                        <tr>
                                            <th><?php echo e(_lang('Amount Limit')); ?></th>
                                            <th><?php echo e(_lang('Charge')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if($deposit_method->chargeLimits()->count() > 0): ?>
                                            <?php $__currentLoopData = $deposit_method->chargeLimits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chargeLimit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($deposit_method->currency->name.' '.$chargeLimit->minimum_amount); ?> - <?php echo e($deposit_method->currency->name.' '.$chargeLimit->maximum_amount); ?></td>
                                                <td><?php echo e(decimalPlace($chargeLimit->fixed_charge, currency($deposit_method->currency->name))); ?> + <?php echo e($chargeLimit->charge_in_percentage); ?>%</td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>				
							</div>
						</div>

                        <?php if($deposit_method->requirements): ?>
                            <?php $__currentLoopData = $deposit_method->requirements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label"><?php echo e($requirement); ?></label>
                                    <input type="text" class="form-control" name="requirements[<?php echo e(str_replace(' ','_',$requirement)); ?>]" value="<?php echo e(old('requirements.'.str_replace(' ', '_', $requirement))); ?>" required>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        <?php if($deposit_method->descriptions != ''): ?>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"><b><?php echo e(_lang('Instructions')); ?></b></label>
                                <div class="border rounded p-2"><?php echo xss_clean($deposit_method->descriptions); ?></div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"><?php echo e(_lang('Description')); ?></label>
                                <textarea class="form-control" name="description"><?php echo e(old('description')); ?></textarea>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"><?php echo e(_lang('Attachment')); ?></label><br>
                                <input type="file" class="dropify" name="attachment" required>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary btn-block" id="submit-btn"><i class="ti-check-box"></i>&nbsp;<?php echo e(_lang('Submit')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
   "use strict";

   var currency = $('#credit_account').find(':selected').data('currency');
   $("#account-currency").html(currency);

    $(document).on('change','#credit_account', function(){
        var currency = $(this).find(':selected').data('currency');
		$("#account-currency").html(currency);
        $("#amount").keyup();
	});

    $(document).on('keyup','#amount', function(){
	  	var from = $("#account-currency").html();
	  	var to = $("#gateway-currency").html();

	  	var amount = $(this).val();

		if($("#credit_account").val() == ''){
			Swal.fire(
				'<?php echo e(_lang('Alert')); ?>',
				'<?php echo e(_lang('Please select credit account first !')); ?>',
				'warning'
			);
			$(this).val('');
			return;
		}

		if(amount != ''){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

			$.ajax({
                method: "POST",
				url: '<?php echo e(route('transfer.get_final_amount')); ?>',
                data: {'from' : from, 'to' : to, 'amount' : amount, 'type' : 'manual_deposit', 'id' : '<?php echo e($deposit_method->id); ?>' },
				beforeSend: function(){
					$("#submit-btn").prop('disabled', true);
				},success: function(data){
					var json = JSON.parse(JSON.stringify(data));

                    if(json['result'] == true){
                        $("#converted_amount").val(parseFloat(json['amount']).toFixed(2));
                        $("#error-msg").html('');
                        $("#submit-btn").prop('disabled', false);
                    }else{
                        $("#converted_amount").val('');
                        $("#error-msg").html(json['message']);
                    }    
					
				}
			});
		}else{
			$("#converted_amount").val('');
		}
  });

})(jQuery);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/customer_portal/deposit/manual_deposit.blade.php ENDPATH**/ ?>