<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-xl-12">
		<div class="card mb-4">
			<div class="card-header">
				<div><?php echo e(_lang('Accounts Overview')); ?></div>
			</div>
			<div class="card-body px-0 pt-0">
				<div class="table-responsive">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th class="text-nowrap pl-4"><?php echo e(_lang('Account Number')); ?></th>
								<th class="text-nowrap"><?php echo e(_lang('Account Type')); ?></th>
								<th><?php echo e(_lang('Currency')); ?></th>
								<th class="text-right"><?php echo e(_lang('Balance')); ?></th>
								<th class="text-nowrap text-right"><?php echo e(_lang('Loan Guarantee')); ?></th>
								<th class="text-nowrap text-right pr-4"><?php echo e(_lang('Current Balance')); ?></th>
							</tr>
						</thead>
						<tbdashboard-customer.blade.phpody>
							<?php $__currentLoopData = get_account_details(auth()->user()->member->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td class="pl-4"><?php echo e($account->account_number); ?></td>
								<td class="text-nowrap"><?php echo e($account->savings_type->name); ?></td>
								<td><?php echo e($account->savings_type->currency->name); ?></td>
								<td class="text-nowrap text-right"><?php echo e(decimalPlace($account->balance, currency($account->savings_type->currency->name))); ?></td>
								<td class="text-nowrap text-right"><?php echo e(decimalPlace($account->blocked_amount, currency($account->savings_type->currency->name))); ?></td>
								<td class="text-nowrap text-right pr-4"><?php echo e(decimalPlace($account->balance - $account->blocked_amount, currency($account->savings_type->currency->name))); ?></td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xl-12">
		<div class="card mb-4">
			<div class="card-header">
				<?php echo e(_lang('Upcoming Loan Payment')); ?>

			</div>
			<div class="card-body px-0 pt-0">
				<div class="table-responsive">
					<table class="table table-bordered">
						<thead>
							<th class="text-nowrap pl-4"><?php echo e(_lang('Loan ID')); ?></th>
							<th class="text-nowrap"><?php echo e(_lang('Next Payment Date')); ?></th>
							<th><?php echo e(_lang('Status')); ?></th>
							<th class="text-nowrap text-right"><?php echo e(_lang('Amount to Pay')); ?></th>
							<th class="text-center"><?php echo e(_lang('Action')); ?></th>
						</thead>
						<tbody>
							<?php if(count($loans) == 0): ?>
								<tr>
									<td colspan="5"><p class="text-center"><?php echo e(_lang('No Data Available')); ?></p></td>
								</tr>
							<?php endif; ?>

							<?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td class="pl-4"><?php echo e($loan->loan_id); ?></td>
								<td class="text-nowrap"><?php echo e($loan->next_payment->repayment_date); ?></td>
								<td><?php echo $loan->next_payment->getRawOriginal('repayment_date') >= date('Y-m-d') ? xss_clean(show_status(_lang('Upcoming'),'success')) : xss_clean(show_status(_lang('Due'),'danger')); ?></td>
								<td class="text-nowrap text-right"><?php echo e(decimalPlace($loan->next_payment->amount_to_pay, currency($loan->currency->name))); ?></td>
								<td class="text-center"><a href="<?php echo e(route('loans.loan_payment',$loan->id)); ?>" class="btn btn-primary btn-xs text-nowrap"><?php echo e(_lang('Pay Now')); ?></a></td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<div class="row">
	<div class="col-xl-12">
		<div class="card mb-4">
			<div class="card-header">
				<?php echo e(_lang('Recent Transactions')); ?>

			</div>
			<div class="card-body px-0 pt-0">
				<div class="table-responsive">
					<table class="table table-bordered">
						<thead>
							<tr>
								<th class="pl-4"><?php echo e(_lang('Date')); ?></th>
								<th><?php echo e(_lang('AC Number')); ?></th>
								<th class="text-right"><?php echo e(_lang('Amount')); ?></th>
								<th><?php echo e(_lang('DR/CR')); ?></th>
								<th><?php echo e(_lang('Type')); ?></th>
								<th><?php echo e(_lang('Status')); ?></th>
								<th class="text-center"><?php echo e(_lang('Details')); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php if(count($recent_transactions) == 0): ?>
								<tr>
									<td colspan="7"><p class="text-center"><?php echo e(_lang('No Data Available')); ?></p></td>
								</tr>
							<?php endif; ?>
							<?php $__currentLoopData = $recent_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<?php
							$symbol = $transaction->dr_cr == 'dr' ? '-' : '+';
							$class  = $transaction->dr_cr == 'dr' ? 'text-danger' : 'text-success';
							?>
							<tr>
								<td class="pl-4"><?php echo e($transaction->trans_date); ?></td>
								<td><?php echo e($transaction->account->account_number); ?> - <?php echo e($transaction->account->savings_type->name); ?> (<?php echo e($transaction->account->savings_type->currency->name); ?>)</td>
								<td class="text-right"><span class="<?php echo e($class); ?>"><?php echo e($symbol.' '.decimalPlace($transaction->amount, currency($transaction->account->savings_type->currency->name))); ?></span></td>
								<td><?php echo e(strtoupper($transaction->dr_cr)); ?></td>
								<td><?php echo e(ucwords(str_replace('_',' ',$transaction->type))); ?></td>
								<td><?php echo xss_clean(transaction_status($transaction->status)); ?></td>
								<td class="text-center"><a href="<?php echo e(route('trasnactions.details', $transaction->id)); ?>" target="_blank" class="btn btn-outline-primary btn-xs"><?php echo e(_lang('View')); ?></a></td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/dashboard-customer.blade.php ENDPATH**/ ?>