<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Bank Balances')); ?></span>
			</div>

			<div class="card-body">
				<?php $date_format = get_option('date_format','Y-m-d'); ?>
				<?php $currency = currency(get_base_currency()); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Bank Account Balances')); ?></h4>
				   <p><?php echo e(_lang('Date').': '. date($date_format)); ?></p>
				</div>

				<table class="table table-bordered report-table">
					<thead>
						<th><?php echo e(_lang('Bank Name')); ?></th>
						<th><?php echo e(_lang('Account Name')); ?></th>
						<th><?php echo e(_lang('Account Number')); ?></th>
						<th><?php echo e(_lang('Currency')); ?></th>
						<th class="text-right pr-4"><?php echo e(_lang('Current Balance')); ?></th>
					</thead>
					<tbody>
						<?php if(isset($accounts)): ?>
						<?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($account->bank_name); ?></td>										
								<td><?php echo e($account->account_name); ?></td>										
								<td><?php echo e($account->account_number); ?></td>										
								<td><?php echo e($account->currency->name); ?></td>										
								<td class="text-right pr-4"><?php echo e(decimalPlace($account->balance, currency($account->currency->name))); ?></td>										
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/reports/bank_balances.blade.php ENDPATH**/ ?>