<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card">

            <div class="card-header d-flex align-items-center">
                <span class="header-title"><?php echo e(_lang('User List')); ?></span>
                <a class="btn btn-primary btn-xs ml-auto"
                    href="<?php echo e(route('users.create')); ?>"><i class="ti-plus"></i>&nbsp;<?php echo e(_lang('Add New')); ?></a>
            </div>

            <div class="card-body">
                <table id="users_table" class="table table-bordered data-table">
                    <thead>
                        <tr>
                            <th class="text-center">#</th>
                            <th><?php echo e(_lang('Name')); ?></th>
                            <th><?php echo e(_lang('Email')); ?></th>
                            <th><?php echo e(_lang('User Type')); ?></th>
                            <th><?php echo e(_lang('Role')); ?></th>
                            <th><?php echo e(_lang('Status')); ?></th>
                            <th class="text-center"><?php echo e(_lang('Action')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr data-id="row_<?php echo e($user->id); ?>">
                            <td class='profile_picture text-center'><img
                                    src="<?php echo e(profile_picture($user->profile_picture)); ?>" class="thumb-sm img-thumbnail">
                            </td>
                            <td class='name'><?php echo e($user->name); ?></td>
                            <td class='email'><?php echo e($user->email); ?></td>
                            <td class='user_type'><?php echo e(strtoupper($user->user_type)); ?></td>
                            <td class='role_id'><?php echo e($user->role->name); ?></td>
                            <td class='status'><?php echo xss_clean(user_status($user->status)); ?></td>
                            <td class="text-center">
                                <span class="dropdown">
                                    <button class="btn btn-primary dropdown-toggle btn-xs" type="button"
                                        id="dropdownMenuButton" data-toggle="dropdown">
                                        <?php echo e(_lang('Action')); ?>

                                        
                                    </button>
                                    <form action="<?php echo e(route('users.destroy', $user['id'])); ?>" method="post">
                                        <?php echo e(csrf_field()); ?>

                                        <input name="_method" type="hidden" value="DELETE">

                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <a href="<?php echo e(route('users.edit', $user['id'])); ?>"        
                                                class="dropdown-item"><i class="ti-pencil-alt"></i>
                                                <?php echo e(_lang('Edit')); ?></a>
                                            <a href="<?php echo e(route('users.show', $user['id'])); ?>"
                                                data-title="<?php echo e(_lang('User Details')); ?>"
                                                class="dropdown-item ajax-modal"><i class="ti-eye"></i>
                                                <?php echo e(_lang('View')); ?></a>
                                            <button class="btn-remove dropdown-item" type="submit"><i
                                                    class="ti-trash"></i>&nbsp;<?php echo e(_lang('Delete')); ?></button>
                                        </div>
                                    </form>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/user/list.blade.php ENDPATH**/ ?>