<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-12">
		<div class="card">
			<div class="card-header">
				<span class="panel-title"><?php echo e(_lang('Account Balances')); ?></span>
			</div>

			<div class="card-body">

				<?php $date_format = get_option('date_format','Y-m-d'); ?>

				<div class="report-header">
				   <img src="<?php echo e(get_logo()); ?>" class="logo"/>
				   <h4><?php echo e(_lang('Account Balances')); ?></h4>
				   <p><?php echo e(isset($account) ? _lang('Account Name').': '.$account->member->name : ''); ?></p>
				   <p><?php echo e(_lang('Date').': '. date($date_format)); ?></p>
				</div>

				<table class="table table-bordered report-table">
					<thead>
						<th><?php echo e(_lang('Account Number')); ?></th>
						<th class="text-right"><?php echo e(_lang('Balance')); ?></th>
						<th class="text-right"><?php echo e(_lang('Loan Guarantee')); ?></th>
						<th class="text-right"><?php echo e(_lang('Current Balance')); ?></th>
					</thead>
					<tbody>
						<?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($account->account_number); ?> - <?php echo e($account->savings_type->name); ?> (<?php echo e($account->savings_type->currency->name); ?>)</td>
								<td class="text-right"><?php echo e(decimalPlace($account->balance, currency($account->savings_type->currency->name))); ?></td>						
								<td class="text-right"><?php echo e(decimalPlace($account->blocked_amount, currency($account->savings_type->currency->name))); ?></td>						
								<td class="text-right"><?php echo e(decimalPlace($account->balance - $account->blocked_amount, currency($account->savings_type->currency->name))); ?></td>						
							</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				    </tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/oqxudidm/public_html/financial/resources/views/backend/customer_portal/reports/account_balances.blade.php ENDPATH**/ ?>